#!/bin/bash
clear
F="gemipens.txt"
GMI="gemipens.gmi"
TIMEZONE_FILE="timezone.txt"

ts() {
    # Verificar si existe el archivo de zona horaria
    if [ -f "$TIMEZONE_FILE" ]; then
        local user_timezone=$(cat "$TIMEZONE_FILE" | tr -d '[:space:]')
        if [ -n "$user_timezone" ]; then
            # Usar la zona horaria del archivo
            TZ="$user_timezone" date '+%d/%m/%y - %H:%M'
            return
        fi
    fi
    # Usar zona horaria del sistema por defecto
    date '+%d/%m/%y - %H:%M'
}

trim() {
    [ -f "$F" ] && head -n 10 "$F" > tmp.$$ && mv tmp.$$ "$F"
}

# Función para mostrar emojis disponibles en 3 columnas
show_emojis() {
    echo "🎭 Emojis disponibles:"
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
    
    # 3 columnas compactas
printf "%-16s %-2s | %-18s %-2s | %-16s %-2s\n" "😊 Emociones" "" "👥 Personas" "" "💻 Informática" ""
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":)" "😊" "8)" "🤓" ":pc:" "💻"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":(" "😞" ":alien:" "👽" ":disk:" "💾"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":'(" "😢" ":robot:" "🤖" ":gear:" "⚙️"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":@" "🤬" ":cat:" "🐱" ":light:" "💡"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" "O:)" "😇" ":dog:" "🐶" ":game:" "🎮"
printf "%-15s %-2s | %-16s %-2s | %-16s %-2s\n" "(l)" "❤️" ":sunglasses:" "😎" ":time:" "⏰"
echo ""

printf "%-15s %-2s | %-16s %-0s | %-18s %-2s\n" "🌍 Lugares" "" "🎬 Entretenimiento" "" "🍕 Vida Diaria" ""
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":travel:" "✈️" ":music:" "🎵" ":coffee:" "☕"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":beach:" "🏖️" ":book:" "📚" ":food:" "🍕"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":sun:" "☀️" ":star:" "⭐" ":money:" "💰"
printf "%-13s %-2s | %-16s %-2s | %-16s %-2s\n" ":moon:" "🌙" ":fire:" "🔥" "(otro)" "💭"
printf "%-14s %-2s | %-17s %-2s | %-16s %-2s\n" ":rain:" "🌧️" ":movie:" "📽️" "" ""
    
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
}

# Función para determinar el emoji basado en el primer token
get_emoji() {
    local first_word="$1"
    case "$first_word" in
        ":)") echo "😊" ;;
        ":(") echo "😞" ;;
        "(l)") echo "❤️" ;;
        "8)") echo "🤓" ;;
        ":@") echo "🤬" ;;
        ":'(") echo "😢" ;;
        "O:)") echo "😇" ;;
        ":alien:") echo "👽" ;;
        ":robot:") echo "🤖" ;;
        ":fire:") echo "🔥" ;;
        ":star:") echo "⭐" ;;
        ":music:") echo "🎵" ;;
        ":book:") echo "📚" ;;
        ":light:") echo "💡" ;;
        ":coffee:") echo "☕" ;;
        ":rain:") echo "🌧️" ;;
        ":sun:") echo "☀️" ;;
        ":moon:") echo "🌙" ;;
        ":cat:") echo "🐱" ;;
        ":dog:") echo "🐶" ;;
        ":food:") echo "🍕" ;;
        ":travel:") echo "✈️" ;;
        ":game:") echo "🎮" ;;
        ":money:") echo "💰" ;;
        ":time:") echo "⏰" ;;
        ":pc:") echo "💻" ;;
        ":disk:") echo "💾" ;;
        ":gear:") echo "⚙️" ;;
        ":beach:") echo "🏖️" ;;
        ":sunglasses:") echo "😎" ;;
        ":movie:") echo "📽️" ;;
        *) echo "💭" ;;
    esac
}

# Función para crear el archivo gemini
create_gemini() {
    echo "# 💭 Gemipens" > "$GMI"
    echo "Pensamientos de 80 caracteres" >> "$GMI"
    echo "" >> "$GMI"
    echo "## Últimos pens" >> "$GMI"
    
    # Copiar el contenido completo del txt al gmi
    if [ -f "$F" ]; then
        while IFS= read -r line; do
            echo "$line" >> "$GMI"
        done < "$F"
    fi
    
    # Añadir enlace al index al final
    echo "" >> "$GMI"
    echo "=> index.gmi Volver al índice" >> "$GMI"
}

# Mostrar emojis disponibles
show_emojis

echo "📝 Texto (max 80 chars) - Usa un código de arriba o escribe normal:"
read -r t

if [ ${#t} -gt 80 ]; then
    echo "❌ Error: Max 80 chars (tienes ${#t})"
    exit 1
fi

[ -z "$t" ] && echo "❌ Error: Texto vacío" && exit 1

# Extraer la primera palabra para determinar el emoji
first_word=$(echo "$t" | awk '{print $1}')
emoji=$(get_emoji "$first_word")

# Si se usó un código de emoji, quitarlo del texto
if [[ "$first_word" == ":)" ]] || [[ "$first_word" == ":(" ]] || [[ "$first_word" == "(l)" ]] || [[ "$first_word" == "8)" ]] || [[ "$first_word" == ":@" ]] || [[ "$first_word" == ":'(" ]] || [[ "$first_word" == "O:)" ]] || [[ "$first_word" == ":alien:" ]] || [[ "$first_word" == ":robot:" ]] || [[ "$first_word" == ":fire:" ]] || [[ "$first_word" == ":star:" ]] || [[ "$first_word" == ":music:" ]] || [[ "$first_word" == ":book:" ]] || [[ "$first_word" == ":light:" ]] || [[ "$first_word" == ":coffee:" ]] || [[ "$first_word" == ":rain:" ]] || [[ "$first_word" == ":sun:" ]] || [[ "$first_word" == ":moon:" ]] || [[ "$first_word" == ":cat:" ]] || [[ "$first_word" == ":dog:" ]] || [[ "$first_word" == ":food:" ]] || [[ "$first_word" == ":travel:" ]] || [[ "$first_word" == ":game:" ]] || [[ "$first_word" == ":money:" ]] || [[ "$first_word" == ":time:" ]] || [[ "$first_word" == ":pc:" ]] || [[ "$first_word" == ":disk:" ]] || [[ "$first_word" == ":gear:" ]] || [[ "$first_word" == ":beach:" ]] || [[ "$first_word" == ":sunglasses:" ]] || [[ "$first_word" == ":movie:" ]]; then
    t=$(echo "$t" | sed "s/^$first_word //")
fi

# Añadir punto al final si no termina con puntuación
if [[ ! "$t" =~ [.!?]$ ]]; then
    t="$t."
fi

# Crear archivo si no existe
touch "$F"

# Añadir nueva entrada al principio del archivo
echo "$(ts): $emoji $t" > tmp.$$
cat "$F" >> tmp.$$
mv tmp.$$ "$F"

trim

# Crear archivo gemini
create_gemini

echo "✅ Guardado en $F"
echo "✅ Generado $GMI"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
cat "$F"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
