#!/bin/bash
clear
F="gemipens.txt"
GMI="gemipens.gmi"
TIMEZONE_FILE="timezone.txt"

ts() {
    # Verificar si existe el archivo de zona horaria
    if [ -f "$TIMEZONE_FILE" ]; then
        local user_timezone=$(cat "$TIMEZONE_FILE" | tr -d '[:space:]')
        if [ -n "$user_timezone" ]; then
            # Usar la zona horaria del archivo
            TZ="$user_timezone" date '+%d/%m/%y - %H:%M'
            return
        fi
    fi
    # Usar zona horaria del sistema por defecto
    date '+%d/%m/%y - %H:%M'
}

trim() {
    [ -f "$F" ] && head -n 10 "$F" > tmp.$$ && mv tmp.$$ "$F"
}

# Función para mostrar emojis disponibles en 3 columnas
show_emojis() {
    echo "🎭 Emojis disponibles:"
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
    
    # 3 columnas compactas
printf "%-16s %-2s | %-18s %-2s | %-16s %-2s\n" "😊 Emociones" "" "👥 Personas" "" "💻 Informática" ""
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":feliz:" "😊" ":listo:" "🤓" ":pc:" "💻"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":triste:" "😞" ":alien:" "👽" ":disco:" "💾"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":lloro:" "😢" ":robot:" "🤖" ":config:" "⚙️"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":enojo:" "🤬" ":gato:" "🐱" ":idea:" "💡"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":angel:" "😇" ":perro:" "🐶" ":juego:" "🎮"
printf "%-15s %-2s | %-16s %-2s | %-16s %-2s\n" ":amor:" "❤️" ":cool:" "😎" ":hora:" "⏰"
echo ""

printf "%-15s %-2s | %-16s %-0s | %-18s %-2s\n" "🌍 Lugares" "" "🎬 Entretenimiento" "" "🍕 Vida Diaria" ""
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":viaje:" "✈️" ":musica:" "🎵" ":cafe:" "☕"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":playa:" "🏖️" ":libro:" "📚" ":comida:" "🍕"
printf "%-14s %-2s | %-16s %-2s | %-16s %-2s\n" ":sol:" "☀️" ":estrella:" "⭐" ":plata:" "💰"
printf "%-13s %-2s | %-16s %-2s | %-16s %-2s\n" ":luna:" "🌙" ":fuego:" "🔥" "(otro)" "💭"
printf "%-14s %-2s | %-17s %-2s | %-16s %-2s\n" ":lluvia:" "🌧️" ":cine:" "📽️" "" ""
    
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
}

# Función para determinar el emoji basado en el primer token
get_emoji() {
    local first_word="$1"
    case "$first_word" in
        ":feliz:") echo "😊" ;;
        ":triste:") echo "😞" ;;
        ":lloro:") echo "😢" ;;
        ":enojo:") echo "🤬" ;;
        ":angel:") echo "😇" ;;
        ":amor:") echo "❤️" ;;
        ":listo:") echo "🤓" ;;
        ":alien:") echo "👽" ;;
        ":robot:") echo "🤖" ;;
        ":gato:") echo "🐱" ;;
        ":perro:") echo "🐶" ;;
        ":cool:") echo "😎" ;;
        ":fuego:") echo "🔥" ;;
        ":estrella:") echo "⭐" ;;
        ":musica:") echo "🎵" ;;
        ":libro:") echo "📚" ;;
        ":cine:") echo "📽️" ;;
        ":idea:") echo "💡" ;;
        ":cafe:") echo "☕" ;;
        ":comida:") echo "🍕" ;;
        ":plata:") echo "💰" ;;
        ":hora:") echo "⏰" ;;
        ":juego:") echo "🎮" ;;
        ":pc:") echo "💻" ;;
        ":disco:") echo "💾" ;;
        ":config:") echo "⚙️" ;;
        ":viaje:") echo "✈️" ;;
        ":playa:") echo "🏖️" ;;
        ":sol:") echo "☀️" ;;
        ":luna:") echo "🌙" ;;
        ":lluvia:") echo "🌧️" ;;
        *) echo "💭" ;;
    esac
}

# Función para crear el archivo gemini
create_gemini() {
    echo "# 💭 Gemipens" > "$GMI"
    echo "Pensamientos de 80 caracteres" >> "$GMI"
    echo "" >> "$GMI"
    echo "## Últimos pens" >> "$GMI"
    
    # Copiar el contenido completo del txt al gmi
    if [ -f "$F" ]; then
        while IFS= read -r line; do
            echo "$line" >> "$GMI"
        done < "$F"
    fi
    
    # Añadir enlace al index al final
    echo "" >> "$GMI"
    echo "=> index.gmi Volver al índice" >> "$GMI"
}

# Mostrar emojis disponibles
show_emojis

echo "📝 Texto (max 80 chars) - Usa un código de arriba o escribe normal:"
read -r t

if [ ${#t} -gt 80 ]; then
    echo "❌ Error: Max 80 chars (tienes ${#t})"
    exit 1
fi

[ -z "$t" ] && echo "❌ Error: Texto vacío" && exit 1

# Extraer la primera palabra para determinar el emoji
first_word=$(echo "$t" | awk '{print $1}')
emoji=$(get_emoji "$first_word")

# Lista de códigos que deben ser removidos
codes_to_remove=":feliz: :triste: :lloro: :enojo: :angel: :amor: :listo: :alien: :robot: :gato: :perro: :cool: :fuego: :estrella: :musica: :libro: :cine: :idea: :cafe: :comida: :plata: :hora: :juego: :pc: :disco: :config: :viaje: :playa: :sol: :luna: :lluvia:"

# Si se usó un código de emoji, quitarlo del texto
if [[ " $codes_to_remove " == *" $first_word "* ]]; then
    t=$(echo "$t" | sed "s/^$first_word //")
fi

# Añadir punto al final si no termina con puntuación
if [[ ! "$t" =~ [.!?]$ ]]; then
    t="$t."
fi

# Crear archivo si no existe
touch "$F"

# Añadir nueva entrada al principio del archivo
echo "$(ts): $emoji $t" > tmp.$$
cat "$F" >> tmp.$$
mv tmp.$$ "$F"

trim

# Crear archivo gemini
create_gemini

echo "✅ Guardado en $F"
echo "✅ Generado $GMI"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
cat "$F"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
