# TUTORIAL COMPLETO DEL SISTEMA ADVENTIA

## Sistema para crear juegos de ficción interactiva en formato Gemini

Versión: 1.0  
Autor: _-Caleb-_
Licencia: Unlicense

## ARCHIVOS NECESARIOS

* game.dat - Información principal del juego
* pages.dat - Todas las páginas y contenido
* genindex.sh - Script que genera index.gmi
* genpag.sh - Script que genera las páginas .gmi

## ESTRUCTURA DE game.dat

El archivo game.dat es texto plano (se abre con cualquier editor de textos simple) y contiene la información global del juego:

```
gametitle: Título del juego
gameauthor: Autor
gameascii: ascii del juego (Inicia en esta línea)
===GAMEINFO_START===
Información del juego
===GAMEINFO_END===
gameversion: 1.0 (Esto no se procesa, es sólo info interna)
com: Comentario (Esto no se procesa)
autorstring: texto "Autor" (Para traducciones y/o mejor personalización)
starstring: texto "Comenzar la aventura" (Para traducciones y/o mejor personalización)

```

### Ejemplo completo:

```
com: Mi primer juego con Adventia
gametitle: Mi Aventura Épica
gameauthor: Autor Creativo
gameascii:
    🏰⚔️🐉
    AVENTURA
     ÉPICA
    ✨📖✨
===GAMEINFO_START===
Bienvenido a una aventura llena de misterio
y emoción. Tus decisiones moldearán el destino.
===GAMEINFO_END===
gameversion: 1.0
autorstring: texto "Escrito por:"
starstring: texto "Iniciar el viaje"

```
## ESTRUCTURA DE pages.dat (también texto plano) 

Cada página tiene esta estructura:

```
id: Número único (01, 02, 03...)
name: Título de la página
ascii: Arte ASCII opcional
desc: Descripción y texto de la página
     Puede contener {{id}} para enlaces
     Puede ser multi-línea
com: Comentarios (no se procesan)
```

### Ejemplo de página:

```
id: 01
name: El Comienzo
ascii:
   🌅🚶‍♂️🌲
  COMIENZO
  DEL VIAJE
   🎒🗺️🎒
desc: Te despiertas en un bosque misterioso. No recuerdas cómo llegaste aquí.
     Puedes {{02}} explorar el bosque o {{03}} buscar ayuda.
com: Página inicial con dos opciones
```
> el ascii: comienza en la línea siguiente al texto ascii: 

## SISTEMA DE NAVEGACIÓN

Los enlaces se crean con {{ID}} en las descripciones:

- Un solo {{id}} = Camino lineal  
  desc: Texto {{02}}

- Múltiples {{id}} = Decisiones del jugador  
  desc: ¿Qué haces? {{02}} o {{03}} o {{04}}

- Sin {{id}} = Final de la historia  
  desc: Fin del juego. ¡Gracias por jugar!

## GENERACIÓN DEL JUEGO

Una vez creados game.dat y pages.dat:

1. Dar permisos de ejecución:
```
chmod +x genindex.sh genpag.sh
```

2. Generar index.gmi:
```
./genindex.sh
```

3. Generar todas las páginas:
```
./genpag.sh
```

4. El juego estará listo en archivos .gmi

## ESTRUCTURA DE ARCHIVOS RESULTANTE

- index.gmi - Página principal con portada
- 01.gmi - Página 1 del juego
- 02.gmi - Página 2 del juego
- ...
- map.gmi - Mapa de conexiones (generado automáticamente)

## BUENAS PRÁCTICAS

1. Usa IDs consecutivos (01, 02, 03...)
2. Mantén el arte ASCII simple y legible
3. Prueba todos los caminos posibles
4. Incluye múltiples finales para rejugabilidad
5. Usa comentarios (com:) para documentar

## EJEMPLO DE JUEGO BÁSICO

### game.dat:
```
gametitle: El Tesoro Perdido
gameauthor: Aventurero Novato
gameascii:
   💎🗺️🏴‍☠️
   TESORO
   PERDIDO
    ⚓🌊⚓
===GAMEINFO_START===
Busca el tesoro legendario del Capitán Barba Negra.
Tus decisiones determinarán si encuentras la fortuna.
===GAMEINFO_END===
```

### pages.dat:
```
id: 01
name: La Playa
ascii:
   🏝️🌊👣
   PLAYA
   DESIERTA
    🐚🌴🐚
desc: Llegas a una playa desierta. Encuentras una botella con un mensaje.
     Puedes {{02}} abrir la botella o {{03}} seguir caminando.
com: Página inicial

id: 02
name: El Mensaje
ascii:
   📜💌🔍
   MENSAJE
   SECRETO
    🕵️‍♂️📖🕵️‍♂️
desc: El mensaje revela la ubicación del tesoro. ¡Estás más cerca!
     {{04}} seguir las pistas.
com: Camino del tesoro

id: 03
name: Explorar la Playa
ascii:
   🚶‍♂️🏝️🔍
   EXPLORACIÓN
   SIN FRUTAS
    🍂🐚🍂
desc: Caminas por la playa pero no encuentras nada interesante.
     Fin de esta aventura.
com: Final aburrido

id: 04
name: El Tesoro
ascii:
   💰🎉🏆
   TESORO
  ENCONTRADO
    ✨💎✨
desc: ¡Encuentras el cofre del tesoro! Eres rico.
     Fin de la aventura - Final Épico.
com: Final exitoso
```

## CONSEJOS

1. Crea ramas que se reconecten luego
2. Usa variables en descripciones (> Item obtenido)
3. Diseña puzzles con múltiples soluciones

## ¡FELIZ AVENTURA!

Con Adventia, puedes crear aventuras emocionantes sin necesidad de programación.

¡Comparte tus creaciones con otros y diviértete!

## Descarga
=> Descargar Adventia 1.2
