#!/bin/bash

# ----------------------------------------
# · ADVENTIA versión 1.0e
#
# · gemini://caleb.subnet.city/adventia/
# ----------------------------------------

input_file="game.dat"
output_file="index.gmi"

# Leer el archivo línea por línea
while IFS= read -r line; do
    # Procesar gametitle
    if [[ "$line" == gametitle:* ]]; then
        gametitle="${line#gametitle: }"
    # Procesar gameauthor
    elif [[ "$line" == gameauthor:* ]]; then
        gameauthor="${line#gameauthor: }"
    # Procesar autorstring (nuevo campo)
    elif [[ "$line" == autorstring:* ]]; then
        autorstring="${line#autorstring: }"
    # Procesar startstring (nuevo campo)
    elif [[ "$line" == startstring:* ]]; then
        startstring="${line#startstring: }"
    # Inicio del arte ASCII (incluyendo la línea que dice "gameascii:")
    elif [[ "$line" == gameascii:* ]]; then
        in_ascii=1
        gameascii="${line#gameascii: }"$'\n'
    # Fin del arte ASCII
    elif [[ "$line" == "===GAMEINFO_START===" ]]; then
        in_ascii=0
        in_info=1
        gameinfo=""
    # Fin de la info
    elif [[ "$line" == "===GAMEINFO_END===" ]]; then
        in_info=0
    # Capturar arte ASCII
    elif [[ $in_ascii -eq 1 ]]; then
        gameascii="$gameascii$line"$'\n'
    # Capturar info del juego
    elif [[ $in_info -eq 1 ]]; then
        gameinfo="$gameinfo$line"$'\n'
    fi
done < "$input_file"

# Valores por defecto si no se especifican los nuevos campos
: ${autorstring:="Autor"}
: ${startstring:="Comenzar la aventura"}

# Crear archivo index.gmi
echo "# $gametitle" > "$output_file"
echo "" >> "$output_file"

if [[ -n "$gameascii" ]]; then
    echo '```' >> "$output_file"
    # Eliminar el último salto de línea extra
    echo -n "${gameascii%$'\n'}" >> "$output_file"
    echo "" >> "$output_file"  # Asegurar salto de línea antes del cierre
    echo '```' >> "$output_file"
    echo "" >> "$output_file"
fi

if [[ -n "$gameinfo" ]]; then
    echo "$gameinfo" >> "$output_file"
fi

if [[ -n "$gameauthor" ]]; then
    echo "" >> "$output_file"
    echo "> $autorstring: $gameauthor" >> "$output_file"
    echo "" >> "$output_file"
fi

echo "=> 01.gmi $startstring" >> "$output_file"

echo "Generado: $output_file 🗺️"
