/* UNLICENSE - This is free and unencumbered software released into the public domain. */

const translations = {
    'es': {
        // Interface
        'app_title': 'Gempub Reader',
        'open_book': '📁 ABRIR LIBRO GPUB',
        'file_help': 'Archivos .gpub (eBook Gemini)',
        'book_info': '📘 INFORMACIÓN DEL LIBRO',
        'chapter_prev': '← Capítulo anterior',
        'chapter_next': 'Capítulo siguiente →',
        'toggle_sidebar': '☰',
        
        // Metadata
        'book_information': 'Información del Libro',
        'title': 'Título',
        'author': 'Autor',
        'description': 'Descripción',
        'language': 'Idioma',
        'published': 'Publicado',
        'publish_date': 'Fecha de publicación',
        'copyright': 'Copyright',
        'license': 'Licencia',
        'cover': 'Portada',
        'unknown_book': 'Libro sin título',
        'unknown_chapter': 'Capítulo desconocido',
        
        // Index
        'table_of_contents': 'Índice',
        'cover_fullview': 'Portada',
        
        // Status
        'loading_error': 'Error al cargar el archivo Gempub',
        'index_error': 'Error al cargar el índice',
        'chapter_error': 'Error al cargar el capítulo',
        'no_cover': 'No se pudo cargar la portada',
        'returning_position': 'Volviendo a tu posición...'
    },
    
    'en': {
        // Interface
        'app_title': 'Gempub Reader',
        'open_book': '📁 OPEN GPUB BOOK',
        'file_help': '.gpub files (Gemini eBook)',
        'book_info': '📘 BOOK INFO',
        'chapter_prev': '← Previous chapter',
        'chapter_next': 'Next chapter →',
        'toggle_sidebar': '☰',
        
        // Metadata
        'book_information': 'Book Information',
        'title': 'Title',
        'author': 'Author',
        'description': 'Description',
        'language': 'Language',
        'published': 'Published',
        'publish_date': 'Publish Date',
        'copyright': 'Copyright',
        'license': 'License',
        'cover': 'Cover',
        'unknown_book': 'Untitled book',
        'unknown_chapter': 'Unknown chapter',
        
        // Index
        'table_of_contents': 'Table of Contents',
        'cover_fullview': 'Cover',
        
        // Status
        'loading_error': 'Error loading Gempub file',
        'index_error': 'Error loading index',
        'chapter_error': 'Error loading chapter',
        'no_cover': 'Could not load cover',
        'returning_position': 'Returning to your position...'
    },
    
    'de': {
        // Interface
        'app_title': 'Gempub Reader',
        'open_book': '📁 GPUB-BUCH ÖFFNEN',
        'file_help': '.gpub-Dateien (Gemini eBook)',
        'book_info': '📘 BUCHINFO',
        'chapter_prev': '← Vorheriges Kapitel',
        'chapter_next': 'Nächstes Kapitel →',
        'toggle_sidebar': '☰',
        
        // Metadata
        'book_information': 'Buchinformationen',
        'title': 'Titel',
        'author': 'Autor',
        'description': 'Beschreibung',
        'language': 'Sprache',
        'published': 'Veröffentlicht',
        'publish_date': 'Veröffentlichungsdatum',
        'copyright': 'Urheberrecht',
        'license': 'Lizenz',
        'cover': 'Umschlag',
        'unknown_book': 'Buch ohne Titel',
        'unknown_chapter': 'Unbekanntes Kapitel',
        
        // Index
        'table_of_contents': 'Inhaltsverzeichnis',
        'cover_fullview': 'Umschlag',
        
        // Status
        'loading_error': 'Fehler beim Laden der Gempub-Datei',
        'index_error': 'Fehler beim Laden des Index',
        'chapter_error': 'Fehler beim Laden des Kapitels',
        'no_cover': 'Umschlag konnte nicht geladen werden',
        'returning_position': 'Kehre zu deiner Position zurück...'
    },
    
    'it': {
        // Interface
        'app_title': 'Gempub Reader',
        'open_book': '📁 APRI LIBRO GPUB',
        'file_help': 'File .gpub (eBook Gemini)',
        'book_info': '📘 INFO LIBRO',
        'chapter_prev': '← Capitolo precedente',
        'chapter_next': 'Capitolo successivo →',
        'toggle_sidebar': '☰',
        
        // Metadata
        'book_information': 'Informazioni del Libro',
        'title': 'Titolo',
        'author': 'Autore',
        'description': 'Descrizione',
        'language': 'Lingua',
        'published': 'Pubblicato',
        'publish_date': 'Data di pubblicazione',
        'copyright': 'Copyright',
        'license': 'Licenza',
        'cover': 'Copertina',
        'unknown_book': 'Libro senza titolo',
        'unknown_chapter': 'Capitolo sconosciuto',
        
        // Index
        'table_of_contents': 'Indice',
        'cover_fullview': 'Copertina',
        
        // Status
        'loading_error': 'Errore nel caricamento del file Gempub',
        'index_error': 'Errore nel caricamento dell\'indice',
        'chapter_error': 'Errore nel caricamento del capitolo',
        'no_cover': 'Impossibile caricare la copertina',
        'returning_position': 'Torno alla tua posizione...'
    },
    
    'ru': {
        // Interface
        'app_title': 'Gempub Reader',
        'open_book': '📁 ОТКРЫТЬ КНИГУ GPUB',
        'file_help': 'Файлы .gpub (Gemini eBook)',
        'book_info': '📘 ИНФОРМАЦИЯ О КНИГЕ',
        'chapter_prev': '← Предыдущая глава',
        'chapter_next': 'Следующая глава →',
        'toggle_sidebar': '☰',
        
        // Metadata
        'book_information': 'Информация о книге',
        'title': 'Название',
        'author': 'Автор',
        'description': 'Описание',
        'language': 'Язык',
        'published': 'Опубликовано',
        'publish_date': 'Дата публикации',
        'copyright': 'Авторские права',
        'license': 'Лицензия',
        'cover': 'Обложка',
        'unknown_book': 'Книга без названия',
        'unknown_chapter': 'Неизвестная глава',
        
        // Index
        'table_of_contents': 'Оглавление',
        'cover_fullview': 'Обложка',
        
        // Status
        'loading_error': 'Ошибка загрузки файла Gempub',
        'index_error': 'Ошибка загрузки оглавления',
        'chapter_error': 'Ошибка загрузки главы',
        'no_cover': 'Не удалось загрузить обложку',
        'returning_position': 'Возвращаюсь к вашей позиции...'
    }
};

class I18n {
    constructor() {
        this.currentLang = this.detectLanguage();
        this.translations = translations;
    }
    
    detectLanguage() {
        // Detectar idioma del navegador
        const browserLang = navigator.language || navigator.userLanguage;
        const baseLang = browserLang.split('-')[0];
        
        // Verificar si tenemos traducción para el idioma detectado
        if (this.translations[baseLang]) {
            return baseLang;
        }
        
        // Fallback a inglés
        return 'en';
    }
    
    setLanguage(lang) {
        if (this.translations[lang]) {
            this.currentLang = lang;
            this.applyTranslations();
        }
    }
    
    t(key) {
        return this.translations[this.currentLang]?.[key] || 
               this.translations['en'][key] || 
               key;
    }
    
    applyTranslations() {
        // Aplicar traducciones a todos los elementos con data-i18n
        document.querySelectorAll('[data-i18n]').forEach(element => {
            const key = element.getAttribute('data-i18n');
            element.textContent = this.t(key);
        });
        
        // Aplicar traducciones a placeholders y valores
        document.querySelectorAll('[data-i18n-placeholder]').forEach(element => {
            const key = element.getAttribute('data-i18n-placeholder');
            element.placeholder = this.t(key);
        });
        
        document.querySelectorAll('[data-i18n-value]').forEach(element => {
            const key = element.getAttribute('data-i18n-value');
            element.value = this.t(key);
        });
    }
    
    getAvailableLanguages() {
        return Object.keys(this.translations);
    }
}

// Exportar para uso global
window.I18n = I18n;